#include <windows>
#include <setupapi>
#include <iostream>
#include <assert>
#include <string>
#include <sysutils.hpp>
#include "usb_R6_2.h"

using namespace std;
//---------------------------------------------------------
TUSBDevice* TUSBDevice::getInstance(){
  if (TUSBDevice::instance == NULL) {
    instance = new TUSBDevice();
  }
  return instance;
}
//---------------------------------------------------------
TUSBDevice::TUSBDevice()
{
   memberIndex = 0;
   hHidLib = NULL;
   deviceInterfaceDetailData = NULL;
   hHidLib = LoadLibrary("HID.DLL");
   if (!hHidLib)
     displayError("Bad doaczenia biblioteki HID.DLL.");

   (FARPROC&) HidD_GetHidGuid=GetProcAddress(hHidLib, "HidD_GetHidGuid");

   if (!HidD_GetHidGuid /*|| !HidD_GetAttributes*/){
      FreeLibrary(hHidLib);
      displayError("Nie znaleziono jednej lub wicej funkcji eksportowych.\n");
   }
}
//---------------------------------------------------------
TUSBDevice::~TUSBDevice()
{
  if(hHidLib != NULL)
    FreeLibrary(hHidLib);
  releaseMemory(TUSBDevice::instance);
}
//---------------------------------------------------------
void TUSBDevice::displayError(const char* msg){
  cout << msg << endl;
  system("PAUSE");
  exit(0);
};
//----------------------------------------------------------
void TUSBDevice::setCharVid(const char* vid)
{
   chVid = vid;
}
//----------------------------------------------------------
string TUSBDevice::getUSBDevicePath(UINT)
{
   HidD_GetHidGuid(&classGuid);
   deviceInfoSet = SetupDiGetClassDevs(&classGuid, NULL, NULL,
                   DIGCF_PRESENT | DIGCF_INTERFACEDEVICE);
   if (deviceInfoSet == INVALID_HANDLE_VALUE){
      FreeLibrary(hHidLib);
      displayError("Nie zidentyfikowano podczonych urzdze.\n");
   }

   deviceInterfaceData.cbSize = sizeof(SP_DEVICE_INTERFACE_DATA);

   SetupDiEnumDeviceInterfaces(deviceInfoSet, NULL, &classGuid,
                                     memberIndex, &deviceInterfaceData);
   SetupDiGetDeviceInterfaceDetail(deviceInfoSet, &deviceInterfaceData,
                             NULL, 0, &deviceInterfaceDetailDataSize, NULL);
   deviceInterfaceDetailData = (PSP_DEVICE_INTERFACE_DETAIL_DATA)
                              new DWORD[deviceInterfaceDetailDataSize];
   deviceInterfaceDetailData->cbSize=sizeof(SP_DEVICE_INTERFACE_DETAIL_DATA);

   if (SetupDiGetDeviceInterfaceDetail(deviceInfoSet, &deviceInterfaceData,
            deviceInterfaceDetailData, deviceInterfaceDetailDataSize,
            NULL, NULL)) {
       pathUSBDevice = deviceInterfaceDetailData->DevicePath;
       //cout << pathUSBDevice << endl;
   }
   releaseMemory(deviceInterfaceDetailData);
   SetupDiDestroyDeviceInfoList(deviceInfoSet);
   return pathUSBDevice;
}
//---------------------------------------------------------
HANDLE TUSBDevice::asynchOpenUSBDevice()
{
   string devUSBpath;
   HANDLE  hidDevObject = INVALID_HANDLE_VALUE;
   while((devUSBpath = getUSBDevicePath(memberIndex++)) != "" ){
     if (NULL != strstr(devUSBpath.c_str(), chVid)){
         cout << endl << devUSBpath <<endl;
         hidDevObject = CreateFile(devUSBpath.c_str(), GENERIC_READ | \
                          GENERIC_WRITE, FILE_SHARE_READ | FILE_SHARE_WRITE,
	                  NULL, OPEN_EXISTING, 0, NULL );
         if(hidDevObject != INVALID_HANDLE_VALUE)
           return  hidDevObject;
           break;
     }
     else
      if (memberIndex > searchMaxDevice)
        displayError("Nie znaleziono urzadzenia o podanym VID\n");
   }
   return  INVALID_HANDLE_VALUE;
}
//---------------------------------------------------------
bool TUSBDevice::asynchReadUSBReport(HANDLE hidDevObject, void *inputReportBuffer,
                                     ULONG inputReportBufferLength)
{
   numberOfBytesRead = 0;
   return ReadFile(hidDevObject, inputReportBuffer,
                   inputReportBufferLength, &numberOfBytesRead, NULL);
}
//---------------------------------------------------------
TUSBDevice *TUSBDevice::instance = NULL;
//---------------------------------------------------------
int main()
{
   HANDLE  hidDeviceObject;
   BYTE inputReportBuffer[bufferLength];

   TUSBDevice *usbDevice = TUSBDevice::getInstance();
  //Asynchroniczne operacje odczytu
   usbDevice->setCharVid("22ba");
   hidDeviceObject = usbDevice->asynchOpenUSBDevice();
     while(true) {
       usbDevice->asynchReadUSBReport(hidDeviceObject, inputReportBuffer,
                                       sizeof(inputReportBuffer));
       printf("%d %d %d %d %d %d %d\n", inputReportBuffer[0],
          inputReportBuffer[1], inputReportBuffer[2],
          inputReportBuffer[3], inputReportBuffer[4],
          inputReportBuffer[5], inputReportBuffer[6]);
       if(inputReportBuffer[6]==64 || \
          hidDeviceObject == INVALID_HANDLE_VALUE){
          break;
        }
     }//koniec while
   Win32Check(CloseHandle(hidDeviceObject));
   system("PAUSE");
   return 0;
}
//---------------------------------------------------------

